<!DOCTYPE html>
<html lang="en">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <!-- Meta, title, CSS, favicons, etc. -->
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <title>DataTables | Gentelella</title>

  <!-- Bootstrap -->
  <link href="../vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Font Awesome -->
  <link href="../vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet">
  <!-- NProgress -->
  <link href="../vendors/nprogress/nprogress.css" rel="stylesheet">
  <!-- iCheck -->
  <link href="../vendors/iCheck/skins/flat/green.css" rel="stylesheet">
  <!-- Datatables -->
  <link href="../vendors/datatables.net-bs/css/dataTables.bootstrap.min.css" rel="stylesheet">
  <link href="../vendors/datatables.net-buttons-bs/css/buttons.bootstrap.min.css" rel="stylesheet">
  <link href="../vendors/datatables.net-fixedheader-bs/css/fixedHeader.bootstrap.min.css" rel="stylesheet">
  <link href="../vendors/datatables.net-responsive-bs/css/responsive.bootstrap.min.css" rel="stylesheet">
  <link href="../vendors/datatables.net-scroller-bs/css/scroller.bootstrap.min.css" rel="stylesheet">

  <!-- Custom Theme Style -->
  <link href="../build/css/custom.min.css" rel="stylesheet">

  <style>
    table.table-striped.table-bordered {
        text-align: center;
    }
    table.table-striped.table-bordered th,
    table.table-striped.table-bordered td {
        text-align: center;
        vertical-align: middle;
    }
  </style>
</head>

<body class="nav-md">
  <div class="container body">
    <div class="main_container">
      <div class="col-md-3 left_col">
        <div class="left_col scroll-view">
          <div class="navbar nav_title" style="border: 0;">
            <a href="index.html" class="site_title"><i class="fa fa-paw"></i> <span>Gentelella Alela!</span></a>
          </div>

          <div class="clearfix"></div>

          <!-- menu profile quick info -->
          <div class="profile clearfix">
            <div class="profile_pic">
              <img src="images/img.jpg" alt="..." class="img-circle profile_img">
            </div>
            <div class="profile_info">
              <span>Welcome,</span>
              <h2>John Doe</h2>
            </div>
          </div>
          <!-- /menu profile quick info -->

          <br />

          <!-- /menu footer buttons -->
          <div class="sidebar-footer hidden-small">
            <a data-toggle="tooltip" data-placement="top" title="Settings">
              <span class="glyphicon glyphicon-cog" aria-hidden="true"></span>
            </a>
            <a data-toggle="tooltip" data-placement="top" title="FullScreen">
              <span class="glyphicon glyphicon-fullscreen" aria-hidden="true"></span>
            </a>
            <a data-toggle="tooltip" data-placement="top" title="Lock">
              <span class="glyphicon glyphicon-eye-close" aria-hidden="true"></span>
            </a>
            <a data-toggle="tooltip" data-placement="top" title="Logout" href="login.html">
              <span class="glyphicon glyphicon-off" aria-hidden="true"></span>
            </a>
          </div>
          <!-- /menu footer buttons -->
        </div>
      </div>

      <!-- page content -->
      <div class="right_col" role="main">
        <div class="">
          <div class="page-title">
            <div class="title_left">
              <h3>Users <small>Some examples to get you started</small></h3>
            </div>

            <div class="title_right">
              <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                <div class="input-group">
                  <input type="text" class="form-control" placeholder="Search for...">
                  <span class="input-group-btn">
                    <button class="btn btn-default" type="button">Go!</button>
                  </span>
                </div>
              </div>
            </div>
          </div>

          <div class="clearfix"></div>

          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="x_panel">
              <div class="x_title">
                <h2>Responsive example<small>Users</small></h2>
                <ul class="nav navbar-right panel_toolbox">
                  <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a></li>
                  <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false"><i class="fa fa-wrench"></i></a>
                    <ul class="dropdown-menu" role="menu">
                      <li><a href="#">Settings 1</a></li>
                      <li><a href="#">Settings 2></a></li>
                    </ul>
                  </li>
                  <li><a class="close-link"><i class="fa fa-close"></i></a></li>
                </ul>
                <div class="clearfix"></div>
              </div>
              <div class="x_content">
                <p class="text-muted font-13 m-b-30">
                  Responsive is an extension for DataTables that resolves that problem by optimising the table's layout for different screen sizes through the dynamic insertion and removal of columns from the table.
                </p>

                <table id="datatable-responsive" class="table table-striped table-bordered dt-responsive nowrap" cellspacing="0" width="100%">
                  <thead>
                    <tr>
                      <th>Data</th>
                      <th>Lids atendidos</th>
                      <th>Lids perdidos</th>
                      <th>Sessoes</th>
                      <th>Média de envios</th>
                      <th>Despesa Aproximada</th>
                      <th>0</th>
                      <th>1</th>
                      <th>2</th>
                      <th>3</th>
                      <th>4</th>
                      <th>5</th>
                      <th>6</th>
                      <th>7</th>
                      <th>8</th>
                      <th>9</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php
                      // Conecte-se ao banco de dados
                      $servername = "br386.hostgator.com.br:3306";
                      $username = "onabet10_dashboard";
                      $password = "102030Bacon!";
                      $dbname = "onabet10_brejonetwork";
                      $conn = new mysqli($servername, $username, $password, $dbname);
                      $conn->set_charset("utf8mb4");

                      if ($conn->connect_error) {
                          die("Connection failed: " . $conn->connect_error);
                      }

                      // Gera as datas no formato desejado
                      for ($i = 0; $i <= 20; $i++) {
                          $date = date('d/m/y', strtotime("-$i days"));
                          $date_db_format = date('Y-m-d', strtotime("-$i days"));
                          
                          // Consulta para contar os lids atendidos
                          $sql = "SELECT COUNT(*) AS lids_atendidos FROM dados_whatsapp WHERE DATE(data_envio) = '$date_db_format'";
                          $result = $conn->query($sql);
                          $row = $result->fetch_assoc();
                          $lids_atendidos = $row['lids_atendidos'];

                          // Consulta para contar os lids perdidos
                          $sql = "SELECT COUNT(*) AS lids_perdidos FROM dados_whatsapp WHERE DATE(data_coleta) = '$date_db_format' AND status = 'aguardando'";
                          $result = $conn->query($sql);
                          $row = $result->fetch_assoc();
                          $lids_perdidos = $row['lids_perdidos'];

                          // Consulta para contar as sessoes
                          $sql = "SELECT COUNT(*) AS sessoes FROM secoes WHERE DATE(data_inicio) = '$date_db_format'";
                          $result = $conn->query($sql);
                          $row = $result->fetch_assoc();
                          $sessoes = $row['sessoes'];

                          // Calcula a média por sessões
                          $media_por_sessoes = $sessoes > 0 ? $lids_atendidos / $sessoes : 0;

                          // Calcula a despesa aproximada
                          $despesa_aproximada = $sessoes * 9;

                          echo '<tr>';
                          echo '<td>' . htmlspecialchars($date, ENT_QUOTES, 'UTF-8') . '</td>';
                          echo '<td>' . htmlspecialchars($lids_atendidos, ENT_QUOTES, 'UTF-8') . '</td>';
                          echo '<td>' . htmlspecialchars($lids_perdidos, ENT_QUOTES, 'UTF-8') . '</td>';
                          echo '<td>' . htmlspecialchars($sessoes, ENT_QUOTES, 'UTF-8') . '</td>';
                          echo '<td>' . htmlspecialchars(number_format($media_por_sessoes, 2), ENT_QUOTES, 'UTF-8') . '</td>';
                          echo '<td>' . htmlspecialchars($despesa_aproximada, ENT_QUOTES, 'UTF-8') . '</td>';
                          // Aqui você pode adicionar as outras colunas com dados do banco de dados
                          echo '<td></td>'; // Coluna 0
                          echo '<td></td>'; // Coluna 1
                          echo '<td></td>'; // Coluna 2
                          echo '<td></td>'; // Coluna 3
                          echo '<td></td>'; // Coluna 4
                          echo '<td></td>'; // Coluna 5
                          echo '<td></td>'; // Coluna 6
                          echo '<td></td>'; // Coluna 7
                          echo '<td></td>'; // Coluna 8
                          echo '<td></td>'; // Coluna 9
                          echo '</tr>';
                      }
                      $conn->close();
                    ?>
                  </tbody>
                </table>

              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- /page content -->

      <!-- footer content -->
      <footer>
        <div class="pull-right">
          Gentelella - Bootstrap Admin Template by <a href="https://colorlib.com">Colorlib</a>
        </div>
        <div class="clearfix"></div>
      </footer>
      <!-- /footer content -->
    </div>
  </div>

  <!-- jQuery -->
  <script src="../vendors/jquery/dist/jquery.min.js"></script>
  <!-- Bootstrap -->
  <script src="../vendors/bootstrap/dist/js/bootstrap.min.js"></script>
  <!-- FastClick -->
  <script src="../vendors/fastclick/lib/fastclick.js"></script>
  <!-- NProgress -->
  <script src="../vendors/nprogress/nprogress.js"></script>
  <!-- iCheck -->
  <script src="../vendors/iCheck/icheck.min.js"></script>

  <!-- Custom Theme Scripts -->
  <script src="../build/js/custom.min.js"></script>

</body>
</html>
