<?php
date_default_timezone_set('America/Sao_Paulo'); // Ajuste para o fuso horário de São Paulo, Brasil.

// Conexão com o banco de dados
$mysqli = new mysqli("localhost", "onabet10_dashboarcomu", "102030Bacon!", "onabet10_brejonetwork");

// Verifica se a conexão foi bem-sucedida
if ($mysqli->connect_errno) {
    echo "Falha ao conectar ao MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
}

// Função para buscar o último envio de cada usuário
function buscarUltimoEnvio($usuarios) {
    global $mysqli;
    $usuariosFormatados = implode("', '", $usuarios);
    $query = "SELECT `data_coleta` FROM `dados_whatsapp` WHERE `user_envio` IN ('$usuariosFormatados') ORDER BY `data_coleta` DESC LIMIT 1";
    $resultado = $mysqli->query($query);
    if ($resultado) {
        $row = $resultado->fetch_assoc();
        return $row['data_coleta'] ?? 'Sem dados';
    }
    return 'Erro na consulta';
}

// Função para buscar o total de envios do dia
function buscarTotalEnviosDia($usuarios) {
    global $mysqli;
    $usuariosFormatados = implode("', '", $usuarios);
    $hoje = date("Y-m-d");
    $query = "SELECT COUNT(*) AS total FROM `dados_whatsapp` WHERE `user_envio` IN ('$usuariosFormatados') AND `status` = 'enviado' AND DATE(`data_envio`) = '$hoje'";
    $resultado = $mysqli->query($query);
    if ($resultado) {
        $row = $resultado->fetch_assoc();
        return $row['total'] ?? 0;
    }
    return 0;
}

// Função para buscar o total de sessões do dia para vários nomes de usuário
function buscarTotalSessoesDia($nomes_usuario) {
    global $mysqli;
    $hoje = date("Y-m-d"); // Obtém a data atual no formato ano-mês-dia
    $nomesFormatados = implode("', '", $nomes_usuario); // Formata os nomes para a consulta SQL
    $query = "SELECT COUNT(*) AS total FROM `secoes` WHERE `nome_usuario` IN ('$nomesFormatados') AND DATE(`data_inicio`) = '$hoje'";
    $resultado = $mysqli->query($query);
    if ($resultado) {
        $row = $resultado->fetch_assoc();
        return $row['total'] ?? 0;
    }
    return 0; // Retorna 0 caso não encontre dados ou ocorra um erro
}

// Função para buscar a última sessão do usuário
function buscarUltimaSessao($usuarios) {
    global $mysqli;
    $usuariosFormatados = implode("', '", $usuarios);
    $query = "SELECT `num_secao`, `data_inicio`, `nome_usuario` FROM `secoes` WHERE `nome_usuario` IN ('$usuariosFormatados') ORDER BY `data_inicio` DESC LIMIT 1";
    $resultado = $mysqli->query($query);
    if ($resultado) {
        $row = $resultado->fetch_assoc();
        return $row;
    }
    return null;
}

// Função para buscar o total de envios na última sessão do usuário
function buscarTotalEnviosUltimaSessao($usuario, $num_secao) {
    global $mysqli;
    $query = "SELECT COUNT(*) AS total FROM `dados_whatsapp` WHERE `user_envio` = '$usuario' AND `num_secao` = '$num_secao'";
    $resultado = $mysqli->query($query);
    if ($resultado) {
        $row = $resultado->fetch_assoc();
        return $row['total'] ?? 0;
    }
    return 0;
}

// Inicia a variável que conterá o conteúdo da página
$page_content = '
<div class="right_col" role="main">
  <div class="">
    <div class="page-title">
      <div class="title_left">
        <h3>Relatórios de envio</h3>
      </div>
    </div>

    <div class="clearfix"></div>';

// Nomes dos usuários, seus nomes alternativos e valores específicos
$usuarios = [
    'caddu' => ['nomes' => ['caduUltra', 'caddu'], 'valores' => ['0', '1']],
    'bruno' => ['nomes' => ['bruno', 'brunoULTRA', 'irineu', 'brunonote'], 'valores' => ['2', '3']],
    'will' => ['nomes' => ['willULTRA', 'will'], 'valores' => ['4', '5']],
    'aba' => ['nomes' => ['abaULTRA', 'aba'], 'valores' => ['6', '7']],
    'bola' => ['nomes' => ['bolaULTRA', 'bola'], 'valores' => ['8']],
    'vico' => ['nomes' => ['vicoULTRA', 'vico'], 'valores' => ['9']],
    'mascara' => ['nomes' => ['mascara'], 'valores' => ['7, 8']],
    'kiko' => ['nomes' => ['kiko'], 'valores' => ['4, 5']],
    'preto' => ['nomes' => ['preto'], 'valores' => ['0, 1, 2, 3']]
];

foreach ($usuarios as $nome => $dados) {
    $ultimoEnvio = buscarUltimoEnvio($dados['nomes']);
    $totalDoDia = buscarTotalEnviosDia($dados['nomes']);
    $sessoesHoje = buscarTotalSessoesDia($dados['nomes']);
    $mediaPorSessao = $sessoesHoje > 0 ? round($totalDoDia / $sessoesHoje, 2) : 0; // Calcula a média por sessão diretamente

    // Buscar última sessão e total de envios na última sessão
    $ultimaSessao = buscarUltimaSessao($dados['nomes']);
    $num_secao = $ultimaSessao['num_secao'] ?? 'Sem dados';
    $nome_usuario = $ultimaSessao['nome_usuario'] ?? null;
    $totalEnviosUltimaSessao = $ultimaSessao && $nome_usuario ? buscarTotalEnviosUltimaSessao($nome_usuario, $num_secao) : 'Sem dados';

    $page_content .= '
      <div class="col-md-6 col-sm-6 col-xs-12">
        <div class="x_panel">
          <div class="x_title">
            <h2>' . ucfirst($nome) . ' <small>Finais: ' . implode(', ', $dados['valores']) . '</small></h2>
            <div class="clearfix"></div>
          </div>
          <div class="x_content">
            <table class="table table-hover">
              <thead>
                <tr>
                  <th>Último Envio</th>
                  <th>Sessão Atual</th>
                  <th>Total do dia</th>
                  <th>Media por sessão</th>
                  <th>Sessões no dia</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td>' . $ultimoEnvio . '</td>
                  <td>' . $totalEnviosUltimaSessao . '</td>
                  <td>' . $totalDoDia . '</td>
                  <td>' . $mediaPorSessao . '</td>
                  <td>' . $sessoesHoje . '</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>';
}

// Adiciona o novo bloco de conteúdo aqui
$page_content .= '
            <div class="">
            </div>

            <div class="clearfix"></div>
            
              <div class="title_left">
                <h3>Histórico</h3>
              </div>

            <div class="row">
              <div class="col-md-12 col-sm-12 col-xs-12">
                <div class="x_panel">
                  <div class="x_title">
                    <h2>Últimas 30 sessões <small>Todos</small></h2>
                    <div class="clearfix"></div>
                  </div>
                  <div class="x_content">
                    <table id="datatable-buttons" class="table table-striped table-bordered">
                      <thead>
                        <tr>
                          <th>Data</th>
                          <th>User</th>
                          <th>Sessões Criadas</th>
                          <th>Media por Sessão</th>
                          <th>Total Enviado</th>
                          <th>Lids Perdidos</th>
                        </tr>
                      </thead>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        </div>
        </div>';

// Inclui o arquivo sidebar que usará essa variável para mostrar o conteúdo
include('sidebar.php');
?>
