<?php
// Habilitar a exibição de erros
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Iniciar a sessão, se necessário
session_start();

// Conexão com o banco de dados
$servername = "localhost";
$port = 3306;
$username = "onabet10_dashboarcomu";
$password = "102030Bacon!";
$dbname = "onabet10_brejonetwork";

// Cria conexão
$conn = new mysqli($servername, $username, $password, $dbname, $port);

// Verifica conexão
if ($conn->connect_error) {
    die("Falha na conexão: " . $conn->connect_error);
}

$conn->set_charset("utf8mb4");

// Verifica se é uma requisição AJAX
if (isset($_POST['action'])) {
    $action = $_POST['action'];

    if ($action == 'update') {
        // Código para atualizar a pendência
        $id = $_POST['id'];
        $tarefa = $_POST['tarefa'];
        $prioridade = $_POST['prioridade'];
        $user = $_POST['user'];
        $data = $_POST['data'];
        $status = $_POST['status'];

        // Validação básica
        if (empty($id)) {
            echo "ID é obrigatório.";
            exit;
        }

        // Prepara e executa a consulta de atualização
        $sql = "UPDATE pendencias SET tarefa=?, prioridade=?, user=?, data=?, status=? WHERE id=?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param('sssssi', $tarefa, $prioridade, $user, $data, $status, $id);

        if ($stmt->execute()) {
            echo "success";
        } else {
            echo "Erro ao atualizar: " . $stmt->error;
        }

        $stmt->close();
        $conn->close();
        exit; // Encerra o script após o processamento
    }

    if ($action == 'delete') {
        // Código para deletar a pendência
        $id = $_POST['id'];

        // Validação básica
        if (empty($id)) {
            echo "ID é obrigatório.";
            exit;
        }

        // Prepara e executa a consulta de deleção
        $sql = "DELETE FROM pendencias WHERE id=?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param('i', $id);

        if ($stmt->execute()) {
            echo "success";
        } else {
            echo "Erro ao deletar: " . $stmt->error;
        }

        $stmt->close();
        $conn->close();
        exit; // Encerra o script após o processamento
    }

    if ($action == 'insert') {
        // Código para inserir uma nova pendência
        $tarefa = $_POST['tarefa'];
        $prioridade = $_POST['prioridade'];
        $user = $_POST['user'];
        $data = $_POST['data'];
        $status = $_POST['status'];

        // Validação básica
        if (empty($tarefa) || empty($prioridade) || empty($user) || empty($data) || empty($status)) {
            echo "Todos os campos são obrigatórios.";
            exit;
        }

        // Prepara e executa a consulta de inserção
        $sql = "INSERT INTO pendencias (tarefa, prioridade, user, data, status) VALUES (?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param('sssss', $tarefa, $prioridade, $user, $data, $status);

        if ($stmt->execute()) {
            // Retorna o ID do novo registro
            echo $stmt->insert_id;
        } else {
            echo "Erro ao inserir: " . $stmt->error;
        }

        $stmt->close();
        $conn->close();
        exit; // Encerra o script após o processamento
    }
}

// Inicia a variável que conterá o conteúdo da página
$page_content = '';

// Consulta SQL modificada com ORDER BY para Prioridade e filtrando por user = 'aba'
$sql = "SELECT id, tarefa, prioridade, user, data, status 
        FROM pendencias 
        WHERE user = 'aba'
        ORDER BY FIELD(prioridade, 'Urgente', 'Media', 'Baixa'), prioridade ASC";
$result = $conn->query($sql);

if (!$result) {
    die("Erro ao executar a consulta: " . $conn->error);
}

$page_content .= '
<!-- page content -->
<div class="right_col" role="main">
    <div class="">
        <div class="page-title">
            <div class="title_left">
                <h3>Lista de Pendências</h3>
            </div>
            <div class="title_right">
                <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                    <div class="input-group">
                        <input type="text" class="form-control" id="search-input" placeholder="Pesquisar...">
                        <span class="input-group-btn">
                            <button class="btn btn-default" type="button">Buscar!</button>
                        </span>
                    </div>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>

        <!-- Botão Nova Tarefa -->
        <div class="row">
            <div class="col-md-12">
                <button type="button" class="btn btn-primary" id="add-new-task-btn">Nova Tarefa</button>
            </div>
        </div>
        <br>

        <!-- Tabela -->
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="x_panel">
              <div class="x_title">
                <h3>Lista de Pendências</h3>
                <ul class="nav navbar-right panel_toolbox">
                  <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a></li>
                  <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false"><i class="fa fa-wrench"></i></a>
                    <ul class="dropdown-menu" role="menu">
                      <li><a href="#">Configurações 1</a></li>
                      <li><a href="#">Configurações 2</a></li>
                    </ul>
                  </li>
                  <li><a class="close-link"><i class="fa fa-close"></i></a></li>
                </ul>
                <div class="clearfix"></div>
              </div>
              <div class="x_content">
                <div class="table-responsive">
                  <form id="pendenciasForm">
                  <table class="table table-striped jambo_table bulk_action">
                    <thead>
                      <tr class="headings">
                        <th>
                          <input type="checkbox" id="check-all" class="flat">
                        </th>
                        <th class="column-title">Tarefa</th>
                        <th class="column-title">Prioridade</th>
                        <th class="column-title">User</th>
                        <th class="column-title">Data</th>
                        <th class="column-title">Status</th>
                        <th class="column-title no-link last"><span class="nobr">Ação</span></th>
                      </tr>
                    </thead>
                    <tbody>';

// Verifica se há resultados e constrói as linhas da tabela
if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $page_content .= "<tr class='even pointer'>";
        $page_content .= "<td class='a-center '><input type='checkbox' class='flat' name='table_records'></td>";

        // Tarefa column
        $page_content .= "<td>
            <span class='tarefa_view'>" . htmlspecialchars($row["tarefa"], ENT_QUOTES, 'UTF-8') . "</span>
            <input type='text' class='tarefa_edit form-control' name='tarefa' value='" . htmlspecialchars($row["tarefa"], ENT_QUOTES, 'UTF-8') . "' style='display:none;'>
        </td>";

        // Prioridade column
        $page_content .= "<td>
            <span class='prioridade_view'>" . htmlspecialchars($row["prioridade"], ENT_QUOTES, 'UTF-8') . "</span>
            <input type='text' class='prioridade_edit form-control' name='prioridade' value='" . htmlspecialchars($row["prioridade"], ENT_QUOTES, 'UTF-8') . "' style='display:none;'>
        </td>";

        // User column
        $page_content .= "<td>
            <span class='user_view'>" . htmlspecialchars($row["user"], ENT_QUOTES, 'UTF-8') . "</span>
            <input type='text' class='user_edit form-control' name='user' value='" . htmlspecialchars($row["user"], ENT_QUOTES, 'UTF-8') . "' style='display:none;'>
        </td>";

        // Data column
        $page_content .= "<td>
            <span class='data_view'>" . htmlspecialchars($row["data"], ENT_QUOTES, 'UTF-8') . "</span>
            <input type='date' class='data_edit form-control' name='data' value='" . htmlspecialchars($row["data"], ENT_QUOTES, 'UTF-8') . "' style='display:none;'>
        </td>";

        // Status column
        $page_content .= "<td>
            <span class='status_view'>" . htmlspecialchars($row["status"], ENT_QUOTES, 'UTF-8') . "</span>
            <select name='status' class='status_edit form-control' style='display:none;'>
                <option value='Pendente'" . ($row["status"] == 'Pendente' ? ' selected' : '') . ">Pendente</option>
                <option value='Em Andamento'" . ($row["status"] == 'Em Andamento' ? ' selected' : '') . ">Em Andamento</option>
                <option value='Concluído'" . ($row["status"] == 'Concluído' ? ' selected' : '') . ">Concluído</option>
            </select>
        </td>";

        // Action column
        $page_content .= "<td class='action-column'>
                <button type='button' class='btn btn-primary edit-btn'>Editar</button>
                <button type='button' class='btn btn-success save-btn' data-id='" . $row["id"] . "' style='display:none;'>Salvar</button>
                <button type='button' class='btn btn-danger delete-btn' data-id='" . $row["id"] . "'>Deletar</button>
            </td>";

        $page_content .= "</tr>";
    }
} else {
    $page_content .= "<tr><td colspan='7'>Nenhuma pendência encontrada</td></tr>";
}

$conn->close();

$page_content .= '
                    </tbody>
                  </table>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- /Tabela -->
    </div>
</div>
<!-- /page content -->

<!-- Inclusão do jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- AJAX Script -->
<script>
    $(document).ready(function() {
        // Função para filtrar a tabela com base no texto de entrada
        $("#search-input").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            $("#pendenciasForm tbody tr").filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });

        // Botão de adicionar nova tarefa
        $("#add-new-task-btn").click(function(){
            var newRow = `<tr class="even pointer new-task-row">
                <td class="a-center"><input type="checkbox" class="flat" name="table_records"></td>
                <td><input type="text" class="tarefa_edit form-control" name="tarefa" placeholder="Tarefa"></td>
                <td>
                    <select name="prioridade" class="prioridade_edit form-control">
                        <option value="Urgente">Urgente</option>
                        <option value="Media">Media</option>
                        <option value="Baixa">Baixa</option>
                    </select>
                </td>
                <td><input type="text" class="user_edit form-control" name="user" placeholder="User"></td>
                <td><input type="date" class="data_edit form-control" name="data"></td>
                <td>
                    <select name="status" class="status_edit form-control">
                        <option value="Pendente">Pendente</option>
                        <option value="Em Andamento">Em Andamento</option>
                        <option value="Concluído">Concluído</option>
                    </select>
                </td>
                <td class="action-column">
                    <button type="button" class="btn btn-success save-new-btn">Salvar</button>
                    <button type="button" class="btn btn-danger cancel-new-btn">Cancelar</button>
                </td>
            </tr>`;

            $("#pendenciasForm tbody").prepend(newRow);
        });

        // Botão de salvar nova tarefa
        $(document).on("click", ".save-new-btn", function(){
            var row = $(this).closest("tr");
            var tarefa = row.find("input[name=\'tarefa\']").val();
            var prioridade = row.find("select[name=\'prioridade\']").val();
            var user = row.find("input[name=\'user\']").val();
            var data = row.find("input[name=\'data\']").val();
            var status = row.find("select[name=\'status\']").val();

            // Validação básica no cliente
            if (!tarefa || !prioridade || !user || !data || !status) {
                alert("Todos os campos são obrigatórios.");
                return;
            }

            $.ajax({
                url: "", // Envia para o mesmo arquivo
                type: "POST",
                data: {
                    action: "insert",
                    tarefa: tarefa,
                    prioridade: prioridade,
                    user: user,
                    data: data,
                    status: status
                },
                success: function(response){
                    if (!isNaN(response)) {
                        alert("Nova tarefa adicionada com sucesso!");
                        // Atualiza a linha com os dados salvos
                        row.find(".tarefa_edit").replaceWith("<span class=\'tarefa_view\'>" + tarefa + "</span>");
                        row.find(".prioridade_edit").replaceWith("<span class=\'prioridade_view\'>" + prioridade + "</span>");
                        row.find(".user_edit").replaceWith("<span class=\'user_view\'>" + user + "</span>");
                        row.find(".data_edit").replaceWith("<span class=\'data_view\'>" + data + "</span>");
                        row.find(".status_edit").replaceWith("<span class=\'status_view\'>" + status + "</span>");
                        // Atualiza a coluna de ações
                        row.find(".action-column").html(`
                            <button type="button" class="btn btn-primary edit-btn">Editar</button>
                            <button type="button" class="btn btn-success save-btn" data-id="` + response + `" style="display:none;">Salvar</button>
                            <button type="button" class="btn btn-danger delete-btn" data-id="` + response + `">Deletar</button>
                        `);
                        // Remove a classe que identifica a nova tarefa
                        row.removeClass("new-task-row");
                    } else {
                        alert("Erro ao adicionar nova tarefa: " + response);
                    }
                },
                error: function(xhr, status, error){
                    alert("Erro ao adicionar nova tarefa: " + xhr.responseText);
                }
            });
        });

        // Botão de cancelar nova tarefa
        $(document).on("click", ".cancel-new-btn", function(){
            $(this).closest("tr").remove();
        });

        // Botão de editar
        $(document).on("click", ".edit-btn", function(){
            var row = $(this).closest("tr");

            // Oculta as views e mostra os campos editáveis
            row.find(".tarefa_view").hide();
            row.find(".tarefa_edit").show();

            row.find(".prioridade_view").hide();
            row.find(".prioridade_edit").show();

            row.find(".user_view").hide();
            row.find(".user_edit").show();

            row.find(".data_view").hide();
            row.find(".data_edit").show();

            row.find(".status_view").hide();
            row.find(".status_edit").show();

            // Oculta o botão de editar e mostra o de salvar
            row.find(".edit-btn").hide();
            row.find(".save-btn").show();
        });

        // Botão de salvar edição
        $(document).on("click", ".save-btn", function(){
            var id = $(this).data("id");
            var row = $(this).closest("tr");
            var tarefa = row.find("input[name=\'tarefa\']").val();
            var prioridade = row.find(".prioridade_edit").val();
            var user = row.find("input[name=\'user\']").val();
            var data = row.find("input[name=\'data\']").val();
            var status = row.find("select[name=\'status\']").val();

            // Validação básica no cliente
            if (!tarefa || !prioridade || !user || !data || !status) {
                alert("Todos os campos são obrigatórios.");
                return;
            }

            $.ajax({
                url: "", // Envia para o mesmo arquivo
                type: "POST",
                data: {
                    action: "update",
                    id: id,
                    tarefa: tarefa,
                    prioridade: prioridade,
                    user: user,
                    data: data,
                    status: status
                },
                success: function(response){
                    if (response.trim() === "success") {
                        alert("Dados atualizados com sucesso!");
                        // Atualiza os campos de visualização
                        row.find(".tarefa_view").text(tarefa).show();
                        row.find(".prioridade_view").text(prioridade).show();
                        row.find(".user_view").text(user).show();
                        row.find(".data_view").text(data).show();
                        row.find(".status_view").text(status).show();
                        // Esconde os campos de edição
                        row.find(".tarefa_edit, .prioridade_edit, .user_edit, .data_edit, .status_edit").hide();
                        row.find(".edit-btn").show();
                        row.find(".save-btn").hide();
                    } else {
                        alert("Erro ao atualizar os dados: " + response);
                    }
                },
                error: function(xhr, status, error){
                    alert("Erro ao atualizar os dados: " + xhr.responseText);
                }
            });
        });

        // Botão de deletar
        $(document).on("click", ".delete-btn", function(){
            var id = $(this).data("id");
            var row = $(this).closest("tr");
            if (confirm("Deseja realmente deletar esta pendência?")) {
                $.ajax({
                    url: "", // Envia para o mesmo arquivo
                    type: "POST",
                    data: {
                        action: "delete",
                        id: id
                    },
                    success: function(response){
                        if (response.trim() === "success") {
                            alert("Pendência deletada com sucesso!");
                            row.remove();
                        } else {
                            alert("Erro ao deletar a pendência: " + response);
                        }
                    },
                    error: function(xhr, status, error){
                        alert("Erro ao deletar a pendência: " + xhr.responseText);
                    }
                });
            }
        });
    });
</script>';

// Inclui o arquivo sidebar que usará a variável $page_content
include('sidebar.php');
?>
