<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Tabela Comunidade</title>
    <!-- Bootstrap -->
    <link href="../vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="../vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet">
    <!-- NProgress -->
    <link href="../vendors/nprogress/nprogress.css" rel="stylesheet">
    <!-- bootstrap-daterangepicker -->
    <link href="../vendors/bootstrap-daterangepicker/daterangepicker.css" rel="stylesheet">
    <!-- Custom Theme Style -->
    <link href="../build/css/custom.min.css" rel="stylesheet">
    <style>
        .table th, .table td {
            text-align: center;
        }
        .column-nome {
            width: 200px; /* ajuste a largura conforme necessário */
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
    </style>
</head>
<body class="nav-md">
<div class="container body">
    <div class="main_container">
        <div class="col-md-3 left_col">
            <div class="left_col scroll-view">
                <div class="navbar nav_title" style="border: 0;">
                    <a href="index2.html" class="site_title">
                        <img src="https://i.imgur.com/zglVNHV.gif" alt="Logo" style="width: 50px; height: 50px;">
                        <span>Taínha</span>
                    </a>
                </div>
                <div class="clearfix"></div>
                <div class="profile clearfix">
                    <div class="profile_pic"></div>
                    <div class="profile_info">
                        <span>BEM VINDO,</span>
                        <h2>NOME_USUARIO</h2>
                    </div>
                </div>
                <br>
                <div id="sidebar-menu" class="main_menu_side hidden-print main_menu">
                    <div class="menu_section active">
                        <h3>General</h3>
                        <ul class="nav side-menu" style="">
                            <li><a href="index2.html"><i class="fa fa-home"></i> Home <span class="fa fa-chevron-down"></span></a></li>
                            <li><a><i class="fa fa-edit"></i> Forms <span class="fa fa-chevron-down"></span></a>
                                <ul class="nav child_menu">
                                    <li><a href="cadastro_comunidade.html">Cadastro Comunidade</a></li>
                                    <li><a>...</a></li>
                                </ul>
                            </li>
                            <li class="active"><a><i class="fa fa-table"></i> Tables <span class="fa fa-chevron-down"></span></a>
                                <ul class="nav child_menu" style="display: block;">
                                    <li class="current-page"><a href="table.php">Tables</a></li>
                                    <li><a href="tables_dynamic.html">Table Dynamic</a></li>
                                </ul>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="sidebar-footer hidden-small">
                    <a data-toggle="tooltip" data-placement="top" title="" data-original-title="Settings">
                        <span class="glyphicon glyphicon-cog" aria-hidden="true"></span>
                    </a>
                    <a data-toggle="tooltip" data-placement="top" title="" data-original-title="FullScreen">
                        <span class="glyphicon glyphicon-fullscreen" aria-hidden="true"></span>
                    </a>
                    <a data-toggle="tooltip" data-placement="top" title="" data-original-title="Lock">
                        <span class="glyphicon glyphicon-eye-close" aria-hidden="true"></span>
                    </a>
                    <a data-toggle="tooltip" data-placement="top" title="" href="login.html" data-original-title="Logout">
                        <span class="glyphicon glyphicon-off" aria-hidden="true"></span>
                    </a>
                </div>
            </div>
        </div>
        <div class="top_nav">
            <div class="nav_menu">
                <nav>
                    <div class="nav toggle">
                        <a id="menu_toggle"><i class="fa fa-bars"></i></a>
                    </div>
                    <ul class="nav navbar-nav navbar-right">
                        <li class="">
                            <a href="javascript:;" class="user-profile dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                NOME_USUARIO
                                <span class=" fa fa-angle-down"></span>
                            </a>
                            <ul class="dropdown-menu dropdown-usermenu pull-right">
                                <li><a href="login.html"><i class="fa fa-sign-out pull-right"></i> Log Out</a></li>
                            </ul>
                        </li>
                    </ul>
                </nav>
            </div>
        </div>
        <div class="right_col" role="main" style="min-height: 429px;">
          <div class="">
            <div class="page-title">
              <div class="title_left">
                <h3>Comunidades</h3>
              </div>
            </div>
            <div class="clearfix"></div>
            <div class="row">
              <div class="col-md-12 col-sm-12 col-xs-12">
                <div class="x_panel">
                  <div class="x_title">
                    <h2>Tabela de comunidades</h2>
                    <ul class="nav navbar-right panel_toolbox">
                      <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a></li>
                      <li class="dropdown">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false"><i class="fa fa-wrench"></i></a>
                        <ul class="dropdown-menu" role="menu">
                          <li><a href="#">Settings 1</a></li>
                          <li><a href="#">Settings 2</a></li>
                        </ul>
                      </li>
                      <li><a class="close-link"><i class="fa fa-close"></i></a></li>
                    </ul>
                    <div class="clearfix"></div>
                  </div>
                  <div class="x_content">
                    <div class="table-responsive">
                      <form id="comunidadesForm">
                      <table class="table table-striped jambo_table bulk_action">
                        <thead>
                          <tr class="headings">
                            <th>
                              <input type="checkbox" id="check-all" class="flat">
                            </th>
                            <th class="column-title column-nome">Nome</th>
                            <th class="column-title">G.US</th>
                            <th class="column-title">Redir</th>
                            <th class="column-title">Link Whatsapp</th>
                            <th class="column-title">Status </th>
                            <th class="column-title no-link last"><span class="nobr">Ação</span></th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php
                          // Conexão com o banco de dados
                          $servername = "localhost";
                          $username = "onabet10_will";
                          $password = "102030Bacon!";
                          $dbname = "onabet10_brejonetwork";

                          // Cria conexão
                          $conn = new mysqli($servername, $username, $password, $dbname);

                          // Verifica conexão
                          if ($conn->connect_error) {
                              die("Connection failed: " . $conn->connect_error);
                          }

                          // Define o charset para suportar emojis
                          $conn->set_charset("utf8mb4");

                          // Consulta SQL
                          $sql = "SELECT id, nome_comunidade, g_us, dominio, url, status FROM comunidades";
                          $result = $conn->query($sql);

                          // Gera as linhas da tabela
                          if ($result->num_rows > 0) {
                              while($row = $result->fetch_assoc()) {
                                  echo "<tr class='even pointer'>";
                                  echo "<td class='a-center '><input type='checkbox' class='flat' name='table_records'></td>";
                                  echo "<td class='nome_comunidade_view column-nome'>" . htmlspecialchars($row["nome_comunidade"], ENT_QUOTES, 'UTF-8') . "</td>";
                                  echo "<td class='g_us_view'>" . htmlspecialchars($row["g_us"], ENT_QUOTES, 'UTF-8') . "</td>";
                                  echo "<td class='dominio_view'><a href='" . htmlspecialchars($row["dominio"], ENT_QUOTES, 'UTF-8') . "' target='_blank'>" . htmlspecialchars($row["dominio"], ENT_QUOTES, 'UTF-8') . "</a></td>";
                                  echo "<td class='url_view'><a href='" . htmlspecialchars($row["url"], ENT_QUOTES, 'UTF-8') . "' target='_blank'>" . htmlspecialchars($row["url"], ENT_QUOTES, 'UTF-8') . "</a></td>";
                                  echo "<td class='status_view'>" . htmlspecialchars($row["status"], ENT_QUOTES, 'UTF-8') . "</td>";

                                  echo "<td class='nome_comunidade_edit' style='display:none;'><input type='text' name='nome_comunidade[]' value='" . htmlspecialchars($row["nome_comunidade"], ENT_QUOTES, 'UTF-8') . "' disabled></td>";
                                  echo "<td class='g_us_edit' style='display:none;'><input type='text' name='g_us[]' value='" . htmlspecialchars($row["g_us"], ENT_QUOTES, 'UTF-8') . "' disabled></td>";
                                  echo "<td class='dominio_edit' style='display:none;'><input type='text' name='dominio[]' value='" . htmlspecialchars($row["dominio"], ENT_QUOTES, 'UTF-8') . "' disabled></td>";
                                  echo "<td class='url_edit' style='display:none;'><input type='text' name='url[]' value='" . htmlspecialchars($row["url"], ENT_QUOTES, 'UTF-8') . "' disabled></td>";
                                  echo "<td class='status_edit' style='display:none;'>
                                    <select name='status[]' disabled>
                                        <option value='Conectado'" . ($row["status"] == 'Conectado' ? ' selected' : '') . ">Conectado</option>
                                        <option value='Aguardando'" . ($row["status"] == 'Aguardando' ? ' selected' : '') . ">Aguardando</option>
                                    </select>
                                  </td>";
                                  echo "<td class=' '><button type='button' class='btn btn-primary edit-btn'>Editar</button> <button type='button' class='btn btn-success save-btn' data-id='" . $row["id"] . "' style='display:none;'>Salvar</button> <button type='button' class='btn btn-danger delete-btn' data-id='" . $row["id"] . "'>Deletar</button></td>";
                                  echo "</tr>";
                              }
                          } else {
                              echo "<tr><td colspan='7'>Nenhuma comunidade encontrada</td></tr>";
                          }

                          $conn->close();
                          ?>
                        </tbody>
                      </table>
                      </form>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <footer>
            <div class="pull-right">
                Gudang Enterprise - Uso exclusivo da Firma da Peixaria 
            </div>
            <div class="clearfix"></div>
        </footer>
    </div>
</div>
<!-- jQuery -->
<script src="../vendors/jquery/dist/jquery.min.js"></script>
<!-- Bootstrap -->
<script src="../vendors/bootstrap/dist/js/bootstrap.min.js"></script>
<!-- FastClick -->
<script src="../vendors/fastclick/lib/fastclick.js"></script>
<!-- NProgress -->
<script src="../vendors/nprogress/nprogress.js"></script>
<!-- validator -->
<script src="../vendors/validator/validator.js"></script>
<!-- Custom Theme Scripts -->
<script src="../build/js/custom.min.js"></script>
<script>
$(document).ready(function(){
    $('.edit-btn').click(function(){
        var row = $(this).closest('tr');
        row.find('.nome_comunidade_view, .g_us_view, .dominio_view, .url_view, .status_view').hide();
        row.find('.nome_comunidade_edit, .g_us_edit, .dominio_edit, .url_edit, .status_edit').show().find('input, select').prop('disabled', false);
        row.find('.edit-btn').hide();
        row.find('.save-btn').show();
    });

    $('.save-btn').click(function(){
        var id = $(this).data('id');
        var row = $(this).closest('tr');
        var nome_comunidade = row.find('input[name="nome_comunidade[]"]').val();
        var g_us = row.find('input[name="g_us[]"]').val();
        var dominio = row.find('input[name="dominio[]"]').val();
        var url = row.find('input[name="url[]"]').val();
        var status = row.find('select[name="status[]"]').val();

        $.ajax({
            url: 'update_comunidade.php',
            type: 'POST',
            data: {
                id: id,
                nome_comunidade: nome_comunidade,
                g_us: g_us,
                dominio: dominio,
                url: url,
                status: status
            },
            success: function(response){
                alert('Dados atualizados com sucesso!');
                row.find('.nome_comunidade_view').text(nome_comunidade).show();
                row.find('.g_us_view').text(g_us).show();
                row.find('.dominio_view').html('<a href="'+ dominio +'" target="_blank">'+ dominio +'</a>').show();
                row.find('.url_view').html('<a href="'+ url +'" target="_blank">'+ url +'</a>').show();
                row.find('.status_view').text(status).show();
                row.find('.nome_comunidade_edit, .g_us_edit, .dominio_edit, .url_edit, .status_edit').hide().find('input, select').prop('disabled', true);
                row.find('.edit-btn').show();
                row.find('.save-btn').hide();
            },
            error: function(){
                alert('Erro ao atualizar os dados.');
            }
        });
    });

    $('.delete-btn').click(function(){
        var id = $(this).data('id');
        var row = $(this).closest('tr');
        if (confirm('Deseja realmente deletar esta comunidade?')) {
            $.ajax({
                url: 'delete_comunidade.php',
                type: 'POST',
                data: { id: id },
                success: function(response){
                    alert('Comunidade deletada com sucesso!');
                    row.remove();
                },
                error: function(){
                    alert('Erro ao deletar a comunidade.');
                }
            });
        }
    });
});
</script>
</body>
</html>
