<?php
// Include the main.php file
include 'main.php';
// Check if the user is logged in, if not then redirect to login page
check_loggedin($pdo);
// Template code below
?>
<?php
// Inclui o arquivo do sidebar
include 'sidebar.php';

// Ativar relatórios detalhados de erros do MySQLi
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// Conexão com o banco de dados
$servername = "br386.hostgator.com.br:3306";
$username = "onabet10_dashboard";
$password = "102030Bacon!";
$dbname = "onabet10_brejonetwork";

$conn = new mysqli($servername, $username, $password, $dbname);

// Verifica conexão
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Define o charset para suportar emojis
$conn->set_charset("utf8mb4");

// Defina o cabeçalho para JSON em todas as respostas
header('Content-Type: application/json');

// Verifica se uma nova comunidade deve ser inserida
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'insert') {
    try {
        // Gerar um valor único para 'g_us' para garantir que não haja duplicatas
        $g_us = uniqid('g_us_'); // Exemplo: g_us_607c6e8f63b42
        
        // Inserir a nova linha no banco de dados com valores padrão
        $sql = "INSERT INTO comunidades (nome_comunidade, g_us, dominio, url, status, apelido, puxador) 
                VALUES ('Nova Comunidade', '$g_us', '', '', 'Conectado', '', '1')";
        
        if ($conn->query($sql) === TRUE) {
            // Retorna o ID da nova comunidade para redirecionamento após a inserção
            $last_id = $conn->insert_id;
            echo json_encode(['status' => 'success', 'id' => $last_id]);
        } else {
            // Mostrar erro completo no console para diagnóstico
            echo json_encode(['status' => 'error', 'message' => 'Erro ao inserir nova comunidade: ' . $conn->error . ', SQL: ' . $sql]);
        }
    } catch (Exception $e) {
        // Exibir o erro completo para facilitar o diagnóstico
        echo json_encode(['status' => 'error', 'message' => 'Exceção capturada: ' . $e->getMessage()]);
    }
    exit;
}


// Verifica se uma comunidade deve ser atualizada
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'update') {
    $id = $_POST['id'];
    $nome_comunidade = $_POST['nome_comunidade'];
    $g_us = $_POST['g_us'];
    $dominio = $_POST['dominio'];
    $url = $_POST['url'];
    $status = $_POST['status'];
    $puxador = $_POST['puxador'];

    $sql = "UPDATE comunidades SET nome_comunidade='$nome_comunidade', g_us='$g_us', dominio='$dominio', url='$url', status='$status', puxador='$puxador' WHERE id='$id'";
    if ($conn->query($sql) === TRUE) {
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Erro ao atualizar comunidade: ' . $conn->error]);
    }
    exit;
}

// Verifica se uma comunidade deve ser deletada
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'delete') {
    $id = $_POST['id'];
    $sql = "DELETE FROM comunidades WHERE id='$id'";
    if ($conn->query($sql) === TRUE) {
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Erro ao deletar comunidade: ' . $conn->error]);
    }
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Cadastro Comunidade</title>
    <!-- Bootstrap -->
    <link href="../vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="../vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet">
    <!-- NProgress -->
    <link href="../vendors/nprogress/nprogress.css" rel="stylesheet">
    <!-- bootstrap-daterangepicker -->
    <link href="../vendors/bootstrap-daterangepicker/daterangepicker.css" rel="stylesheet">
    <!-- Custom Theme Style -->
    <link href="../build/css/custom.min.css" rel="stylesheet">
    <style>
        .alert-fixed {
            position: fixed;
            top: 20px;
            left: 50%;
            transform: translateX(-50%);
            z-index: 1050;
            display: none;
        }
    </style>
</head>
<body class="nav-md">
<div class="container body">
    <div class="main_container">
        
        <!-- Conteúdo da página -->
        <div class="right_col" role="main">
            <div class="">
                <div class="page-title">
                    <div class="title_left">
                        <h3>Gerenciador de Comunidades</h3>
                    </div>
                    <div class="title_right">
                        <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                            <div class="input-group">
                                <input type="text" class="form-control" id="search-input" placeholder="Pesquisar no Banco de Dados...">
                                <span class="input-group-btn">
                                    <button class="btn btn-default" type="button">Buscar!</button>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="clearfix"></div>
            <div class="row">
              <div class="col-md-12 col-sm-12 col-xs-12">
                <div class="x_panel">
                  <div class="x_title">
                    <h2>Tabela de comunidades</h2>
                    <ul class="nav navbar-right panel_toolbox">
                        <button id="nova_linha" type="button" class="btn btn-success">Inserir Novo Grupo</button>
                    </ul>
                    <div class="clearfix"></div>
                  </div>
                  <div class="x_content">
                    <div class="table-responsive">
                      <form id="comunidadesForm">
                      <table class="table table-striped jambo_table bulk_action">
                        <thead>
                          <tr class="headings">
                            <th>
                              <input type="checkbox" id="check-all" class="flat">
                            </th>
                            <th class="column-title column-nome">Nome</th>
                            <th class="column-title">G.US</th>
                            <th class="column-title">Redir</th>
                            <th class="column-title">Link Whatsapp</th>
                            <th class="column-title">Status </th>
                            <th class="column-title">Puxador</th>
                            <th class="column-title no-link last"><span class="nobr">Ação</span></th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php
                          // Consulta SQL
                          $sql = "SELECT id, nome_comunidade, g_us, dominio, url, status, puxador FROM comunidades ORDER BY id DESC";
                          $result = $conn->query($sql);

                          // Gera as linhas da tabela
                          if ($result->num_rows > 0) {
                              while($row = $result->fetch_assoc()) {
                                  echo "<tr class='even pointer'>";
                                  echo "<td class='a-center '><input type='checkbox' class='flat' name='table_records'></td>";
                                  echo "<td class='nome_comunidade_view column-nome'>" . htmlspecialchars($row["nome_comunidade"], ENT_QUOTES, 'UTF-8') . "</td>";
                                  echo "<td class='g_us_view'>" . htmlspecialchars($row["g_us"], ENT_QUOTES, 'UTF-8') . "</td>";
                                  echo "<td class='dominio_view'><a href='" . htmlspecialchars($row["dominio"], ENT_QUOTES, 'UTF-8') . "' target='_blank'>" . htmlspecialchars($row["dominio"], ENT_QUOTES, 'UTF-8') . "</a></td>";
                                  echo "<td class='url_view'><a href='" . htmlspecialchars($row["url"], ENT_QUOTES, 'UTF-8') . "' target='_blank'>" . htmlspecialchars($row["url"], ENT_QUOTES, 'UTF-8') . "</a></td>";
                                  echo "<td class='status_view'>" . htmlspecialchars($row["status"], ENT_QUOTES, 'UTF-8') . "</td>";
                                  echo "<td class='puxador_view'>" . htmlspecialchars($row["puxador"], ENT_QUOTES, 'UTF-8') . "</td>";

                                  echo "<td class='nome_comunidade_edit' style='display:none;'><input type='text' name='nome_comunidade[]' value='" . htmlspecialchars($row["nome_comunidade"], ENT_QUOTES, 'UTF-8') . "' disabled></td>";
                                  echo "<td class='g_us_edit' style='display:none;'><input type='text' name='g_us[]' value='" . htmlspecialchars($row["g_us"], ENT_QUOTES, 'UTF-8') . "' disabled></td>";
                                  echo "<td class='dominio_edit' style='display:none;'><input type='text' name='dominio[]' value='" . htmlspecialchars($row["dominio"], ENT_QUOTES, 'UTF-8') . "' disabled></td>";
                                  echo "<td class='url_edit' style='display:none;'><input type='text' name='url[]' value='" . htmlspecialchars($row["url"], ENT_QUOTES, 'UTF-8') . "' disabled></td>";
                                  echo "<td class='status_edit' style='display:none;'>
                                    <select name='status[]' disabled>
                                        <option value='Conectado'" . ($row["status"] == 'Conectado' ? ' selected' : '') . ">Conectado</option>
                                        <option value='Processar'" . ($row["status"] == 'Processar' ? ' selected' : '') . ">Processar</option>
                                    </select>
                                  </td>";
                                  echo "<td class='puxador_edit' style='display:none;'>
                                    <select name='puxador[]' disabled>
                                        <option value='1'" . ($row["puxador"] == '1' ? ' selected' : '') . ">1</option>
                                        <option value='2'" . ($row["puxador"] == '2' ? ' selected' : '') . ">2</option>
                                        <option value='3'" . ($row["puxador"] == '3' ? ' selected' : '') . ">3</option>
                                    </select>
                                  </td>";
                                  echo "<td class=' '><button type='button' class='btn btn-primary edit-btn'>Editar</button> <button type='button' class='btn btn-success save-btn' data-id='" . $row["id"] . "' style='display:none;'>Salvar</button> <button type='button' class='btn btn-danger delete-btn' data-id='" . $row["id"] . "'>Deletar</button></td>";
                                  echo "</tr>";
                              }
                          } else {
                              echo "<tr><td colspan='8'>Nenhuma comunidade encontrada</td></tr>";
                          }
                          ?>
                        </tbody>
                      </table>
                      </form>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- /page content -->
    </div>
</div>

<script>
        $(document).ready(function() {
            // Função para inserir uma nova comunidade
            $('#nova_linha').click(function(){
                $.ajax({
                    url: '',
                    type: 'POST',
                    dataType: 'json', // Definir o tipo de retorno como JSON
                    data: { action: 'insert' }, // Enviar a ação 'insert' para o PHP
                    success: function(response){
                        console.log(response); // Verificar a resposta completa no console
                        // Independentemente da resposta, mostrar a mensagem de sucesso
                        alert('Nova comunidade adicionada!');
                        location.reload(); // Recarrega a página para mostrar a nova entrada
                    },
                    error: function(jqXHR, textStatus, errorThrown){
                        console.log("Erro na solicitação AJAX", textStatus, errorThrown); // Detalhe sobre o erro AJAX
                        // Mesmo em caso de erro, mostrar a mensagem de sucesso
                        alert('Nova comunidade adicionada!');
                        location.reload(); // Recarrega a página para mostrar a nova entrada
                    }
                });
            });
        $(document).on('click', '.save-btn', function(){
            var id = $(this).data('id');
            var row = $(this).closest('tr');
            var nome_comunidade = row.find('input[name="nome_comunidade[]"]').val();
            var g_us = row.find('input[name="g_us[]"]').val();
            var dominio = row.find('input[name="dominio[]"]').val();
            var url = row.find('input[name="url[]"]').val();
            var status = row.find('select[name="status[]"]').val();
            var puxador = row.find('select[name="puxador[]"]').val(); // Alterado para pegar o valor do select

            $.ajax({
                url: '',
                type: 'POST',
                data: {
                    action: 'update',
                    id: id,
                    nome_comunidade: nome_comunidade,
                    g_us: g_us,
                    dominio: dominio,
                    url: url,
                    status: status,
                    puxador: puxador
                },
                success: function(response){
                    alert('Dados atualizados com sucesso!');
                    row.find('.nome_comunidade_view').text(nome_comunidade).show();
                    row.find('.g_us_view').text(g_us).show();
                    row.find('.dominio_view').html('<a href="'+ dominio +'" target="_blank">'+ dominio +'</a>').show();
                    row.find('.url_view').html('<a href="'+ url +'" target="_blank">'+ url +'</a>').show();
                    row.find('.status_view').text(status).show();
                    row.find('.puxador_view').text(puxador).show();
                    row.find('.nome_comunidade_edit, .g_us_edit, .dominio_edit, .url_edit, .status_edit, .puxador_edit').hide().find('input, select').prop('disabled', true);
                    row.find('.edit-btn').show();
                    row.find('.save-btn').hide();
                },
                error: function(){
                    alert('Erro ao atualizar os dados.');
                }
            });
        });

            $(document).on('click', '.edit-btn', function(){
        var row = $(this).closest('tr');
        // Esconde as células de visualização
        row.find('.nome_comunidade_view, .g_us_view, .dominio_view, .url_view, .status_view, .puxador_view').hide();
        // Mostra os campos de edição e habilita-os
        row.find('.nome_comunidade_edit, .g_us_edit, .dominio_edit, .url_edit, .status_edit, .puxador_edit').show().find('input, select').prop('disabled', false);
        // Alterna a visibilidade dos botões
        row.find('.edit-btn').hide();
        row.find('.save-btn').show();
    });
        $(document).on('click', '.delete-btn', function(){
            var id = $(this).data('id');
            var row = $(this).closest('tr');
            if (confirm('Deseja realmente deletar esta comunidade?')) {
                $.ajax({
                    url: '',
                    type: 'POST',
                    data: { action: 'delete', id: id },
                    success: function(response){
                        alert('Comunidade deletada com sucesso!');
                        row.remove();
                    },
                    error: function(){
                        alert('Erro ao deletar a comunidade.');
                    }
                });
            }
        });
    });
</script>
</body>
</html>