<?php
header('Content-Type: application/json');

// Dados de acesso ao banco de dados
$servername = "br386.hostgator.com.br";
$username = "onabet10_dashboard";
$password = "102030Bacon!";
$dbname = "onabet10_brejonetwork";

// Conecta ao banco de dados
$conn = new mysqli($servername, $username, $password, $dbname);

// Verifica se a conexão foi bem-sucedida
if ($conn->connect_error) {
    echo json_encode(["status" => "error", "message" => "Connection failed: " . $conn->connect_error]);
    exit();
}

// Define o charset para utf8mb4
$conn->set_charset("utf8mb4");

// Recupera os dados do formulário
$dominio = $_POST['website_redir'];
$url = $_POST['website_whatsapp'];
$nome_comunidade = $_POST['name'];
$g_us = isset($_POST['email']) ? $_POST['email'] : null; // Torna o campo opcional
$status = $_POST['opcoes'];

// Verifica se o g_us já existe no banco de dados (apenas se não for nulo)
if ($g_us) {
    $sql_check = "SELECT * FROM comunidades WHERE g_us = ?";
    $stmt_check = $conn->prepare($sql_check);
    $stmt_check->bind_param("s", $g_us);
    $stmt_check->execute();
    $stmt_check->store_result();

    if ($stmt_check->num_rows > 0) {
        echo json_encode(["status" => "error", "message" => "Erro: O g.us já está cadastrado no banco de dados."]);
        $stmt_check->close();
        $conn->close();
        exit();
    }

    $stmt_check->close();
}

// Prepara a consulta SQL para inserir os dados
$sql = "INSERT INTO comunidades (dominio, url, nome_comunidade, g_us, status) VALUES (?, ?, ?, ?, ?)";
$stmt = $conn->prepare($sql);
$stmt->bind_param("sssss", $dominio, $url, $nome_comunidade, $g_us, $status);

// Executa a consulta
if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "Nova comunidade inserida com sucesso!"]);
} else {
    echo json_encode(["status" => "error", "message" => "Erro: " . $sql . "<br>" . $conn->error]);
}

// Fecha a conexão
$stmt->close();
$conn->close();
?>
