<?php
// Defina o conteúdo da página, incluindo a consulta ao banco de dados
$page_content = '
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <!-- Meta, title, CSS, favicons, etc. -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>DataTables | Gentelella</title>

    <!-- Bootstrap -->
    <link href="../vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="../vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet">
    <!-- NProgress -->
    <link href="../vendors/nprogress/nprogress.css" rel="stylesheet">
    <!-- iCheck -->
    <link href="../vendors/iCheck/skins/flat/green.css" rel="stylesheet">
    <!-- Datatables -->
    <link href="../vendors/datatables.net-bs/css/dataTables.bootstrap.min.css" rel="stylesheet">
    <link href="../vendors/datatables.net-buttons-bs/css/buttons.bootstrap.min.css" rel="stylesheet">
    <link href="../vendors/datatables.net-fixedheader-bs/css/fixedHeader.bootstrap.min.css" rel="stylesheet">
    <link href="../vendors/datatables.net-responsive-bs/css/responsive.bootstrap.min.css" rel="stylesheet">
    <link href="../vendors/datatables.net-scroller-bs/css/scroller.bootstrap.min.css" rel="stylesheet">

    <!-- Custom Theme Style -->
    <link href="../build/css/custom.min.css" rel="stylesheet">
  </head>
<!-- page content -->
<div class="right_col" role="main">
  <div class="">
    <div class="page-title">
      <div class="title_left">
        <h3>Status dos serviços</h3>
      </div>

      <div class="title_right">
          <div class="input-group">
          </div>
        </div>
      </div>
    </div>

    <div class="clearfix"></div>
      <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="x_panel">
          <div class="x_title">
            <h2>Scripts</h2>
            <ul class="nav navbar-right panel_toolbox">
              <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
              </li>
              <li class="dropdown">
                <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false"><i class="fa fa-wrench"></i></a>
                <ul class="dropdown-menu" role="menu">
                  <li><a href="#">Settings 1</a>
                  </li>
                  <li><a href="#">Settings 2</a>
                  </li>
                </ul>
              </li>
              <li><a class="close-link"><i class="fa fa-close"></i></a>
              </li>
            </ul>
            <div class="clearfix"></div>
          </div>
          <div class="x_content">
            <p class="text-muted font-13 m-b-30">
              No caso de algum serviço estiver indisponível ou com problemas em reiniciar, avise imediatamente!
            </p>
            <table id="datatable-buttons" class="table table-striped table-bordered" style="text-align: center;">
              <thead style="text-align: center;">
                <tr>
                  <th style="text-align: center;">Script</th>
                  <th style="text-align: center;">Versão</th>
                  <th style="text-align: center;">Última verificação</th>
                  <th style="text-align: center;">Situação</th>
                  <th style="text-align: center;">Ação</th>
                </tr>
              </thead>
              <tbody>';

// Conecte-se ao banco de dados e recupere os dados
$servername = "localhost";
$username = "onabet10_dashboardsodre";
$password = "Careca321@#!";
$dbname = "onabet10_sodrenetwork";
$conn = new mysqli($servername, $username, $password, $dbname);
$conn->set_charset("utf8mb4");

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Array de nomes das colunas e outras informações relevantes
$scripts = [
    ['name' => 'puxador1', 'displayName' => 'Puxador 1', 'version' => '2.1', 'status' => 'Ativo'],
    ['name' => 'puxador2', 'displayName' => 'Puxador 2', 'version' => '2.1', 'status' => 'Desativado'],
    ['name' => 'validador', 'displayName' => 'Validador', 'version' => '1.0', 'status' => 'Ativo'],
    ['name' => 'organizador', 'displayName' => 'Organizador', 'version' => '1.0', 'status' => 'Ativo'],
    ['name' => 'nomeador', 'displayName' => 'Nomeador de comunidades', 'version' => '1.2', 'status' => 'Ativo'],
    ['name' => 'redir', 'displayName' => 'Redir Checker', 'version' => '1.1', 'status' => 'Ativo'],
    ['name' => 'monitor', 'displayName' => 'Monitor', 'version' => '1.1', 'status' => 'Ativo']
];

foreach ($scripts as $script) {
    $sql = "SELECT last_check FROM software WHERE name = '{$script['name']}'";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $last_check = $row['last_check'];

        // Calcular o uptime (diferença entre o last_check e o tempo atual)
        $now = new DateTime();
        $lastCheckTime = new DateTime($last_check);
        $interval = $now->diff($lastCheckTime);
        $uptime = $interval->format('%d dias, %h horas, %i minutos');
        
        // Convertendo o tempo de uptime em minutos para comparação
        $uptime_minutes = ($interval->days * 24 * 60) + ($interval->h * 60) + $interval->i;

        // Verificar a condição para definir a situação
        if ($script['status'] !== 'Desativado') {
            if ($uptime_minutes > 15) {
                $script['status'] = 'Problema Detectado';
            } elseif ($uptime_minutes <= 14) {
                $script['status'] = 'Ativo';
            }
        }
    } else {
        $uptime = 'N/A';
    }

    // Determinar a classe CSS da linha com base na situação
    $row_class = '';
    if ($script['status'] === 'Desativado') {
        $row_class = 'class="bg-lightred"';
    } elseif ($script['status'] === 'Problema Detectado') {
        $row_class = 'class="bg-lightyellow"';
    } elseif ($script['status'] === 'Ativo') {
        $row_class = 'class="bg-lightgreen"';
    }

    // Preencher a linha da tabela
    $page_content .= "
    <tr $row_class>
        <td>{$script['displayName']}</td>
        <td>{$script['version']}</td>
        <td>$uptime</td>
        <td>{$script['status']}</td>
        <td>
            <form method=\"post\">
                <button type=\"submit\" class=\"btn btn-success\" name=\"restart_script\" value=\"{$script['name']}\">Reiniciar</button>
            </form>
        </td>
    </tr>";
}

$page_content .= '
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- /page content -->
';

$conn->close();

// Verificar se um botão de reiniciar foi clicado
if (isset($_POST['restart_script'])) {
    $script_name = $_POST['restart_script'];

    // Comando SSH para reiniciar o script
    $ssh_command = "sshpass -p '102030Bacon!' ssh root@108.181.223.244 './start_screens.sh'";

    // Executar o comando SSH
    exec($ssh_command, $output, $return_var);

    if ($return_var === 0) {
        echo "<p>O script $script_name foi reiniciado com sucesso.</p>";
    } else {
        echo "<p>Erro ao reiniciar o script $script_name.</p>";
    }
}

// Inclua o template da sidebar
include 'sidebar.php';

// Exibir o conteúdo da página
echo $page_content;
?>

<!-- Adicionar CSS para cores de fundo -->
<style>
    .bg-lightred {
        background-color: #ffcccc !important;
    }
    .bg-lightyellow {
        background-color: #ffffcc !important;
    }
    .bg-lightgreen {
        background-color: #ccffcc !important;
    }
</style>
