<?php
date_default_timezone_set('America/Sao_Paulo'); // Ajuste para o fuso horário de São Paulo, Brasil.

// Conexão com o banco de dados
$mysqli = new mysqli("localhost", "onabet10_dashboardsodre", "Careca321@#!", "onabet10_dashboardsodre");

// Verifica se a conexão foi bem-sucedida
if ($mysqli->connect_errno) {
    echo "Falha ao conectar ao MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
}

// Função para buscar o último envio de cada usuário
function buscarUltimoEnvio($usuarios) {
    global $mysqli;
    $usuariosFormatados = implode("', '", $usuarios);
    $query = "SELECT `data_coleta` FROM `dados_whatsapp` WHERE `user_envio` IN ('$usuariosFormatados') ORDER BY `data_coleta` DESC LIMIT 1";
    $resultado = $mysqli->query($query);
    if ($resultado) {
        $row = $resultado->fetch_assoc();
        return $row['data_coleta'] ?? 'Sem dados';
    }
    return 'Erro na consulta';
}

// Função para buscar o total de envios do dia
function buscarTotalEnviosDia($usuarios) {
    global $mysqli;
    $usuariosFormatados = implode("', '", $usuarios);
    $hoje = date("Y-m-d");
    $query = "SELECT COUNT(*) AS total FROM `dados_whatsapp` WHERE `user_envio` IN ('$usuariosFormatados') AND `status` = 'enviado' AND DATE(`data_envio`) = '$hoje'";
    $resultado = $mysqli->query($query);
    if ($resultado) {
        $row = $resultado->fetch_assoc();
        return $row['total'] ?? 0;
    }
    return 0;
}

// Função para buscar o total de sessões do dia para vários nomes de usuário
function buscarTotalSessoesDia($nomes_usuario) {
    global $mysqli;
    $hoje = date("Y-m-d");
    $nomesFormatados = implode("', '", $nomes_usuario);
    $query = "SELECT COUNT(*) AS total FROM `secoes` WHERE `nome_usuario` IN ('$nomesFormatados') AND DATE(`data_inicio`) = '$hoje'";
    $resultado = $mysqli->query($query);
    if ($resultado) {
        $row = $resultado->fetch_assoc();
        return $row['total'] ?? 0;
    }
    return 0;
}

// Função para buscar a última sessão do usuário
function buscarUltimaSessao($usuarios) {
    global $mysqli;
    $usuariosFormatados = implode("', '", $usuarios);
    $query = "SELECT `num_secao`, `data_inicio`, `nome_usuario` FROM `secoes` WHERE `nome_usuario` IN ('$usuariosFormatados') ORDER BY `data_inicio` DESC LIMIT 1";
    $resultado = $mysqli->query($query);
    if ($resultado) {
        $row = $resultado->fetch_assoc();
        return $row;
    }
    return null;
}

// Função para buscar o total de envios na última sessão do usuário
function buscarTotalEnviosUltimaSessao($usuario, $num_secao) {
    global $mysqli;
    $query = "SELECT COUNT(*) AS total FROM `dados_whatsapp` WHERE `user_envio` = '$usuario' AND `num_secao` = '$num_secao'";
    $resultado = $mysqli->query($query);
    if ($resultado) {
        $row = $resultado->fetch_assoc();
        return $row['total'] ?? 0;
    }
    return 0;
}

// Nomes dos usuários, seus nomes alternativos e valores específicos
$usuarios = [
    'caddu' => ['nomes' => ['caddu2', 'caddu'], 'valores' => ['0', '1']],
    'bruno' => ['nomes' => ['bruno', 'bruno2', 'irineu', 'brunonote'], 'valores' => ['2', '3']],
    'will' => ['nomes' => ['willULTRA', 'will', 'will2'], 'valores' => ['4', '5']],
    'aba' => ['nomes' => ['aba2', 'aba'], 'valores' => ['6', '7']],
    'bola' => ['nomes' => ['bolaULTRA', 'bola'], 'valores' => ['8']],
    'vico' => ['nomes' => ['vicoULTRA', 'vico'], 'valores' => ['9']],
    'hobbit' => ['nomes' => ['hobbit'], 'valores' => ['Terceirizado']],
    'preto' => ['nomes' => ['preto'], 'valores' => ['Terceirizado']],
];

// Variáveis para armazenar os totais
$totais = 0;  // Lids Totais = atendidos + perdidos
$atendidos = 0;  // Soma de todos os totalDoDia de cada usuário
$perdidos = 0;  // Inicialmente, vamos calcular

$totaisPorUsuario = [];
$maiorTotalDoDia = 0;
$usuarioComMaiorTotal = '';

// Calcular o total de lids atendidos
foreach ($usuarios as $nome => $dados) {
    $totalDoDia = buscarTotalEnviosDia($dados['nomes']);
    
    // Acumula o total do dia em $atendidos
    $atendidos += $totalDoDia;

    $totaisPorUsuario[$nome] = [
        'dados' => $dados,
        'totalDoDia' => $totalDoDia,
        'ultimoEnvio' => buscarUltimoEnvio($dados['nomes']),
        'sessoesHoje' => buscarTotalSessoesDia($dados['nomes']),
        'ultimaSessao' => buscarUltimaSessao($dados['nomes']),
    ];

    if ($totalDoDia > $maiorTotalDoDia) {
        $maiorTotalDoDia = $totalDoDia;
        $usuarioComMaiorTotal = $nome;
    }
}

// Consulta para contar os lids perdidos com status 'aguardando'
$hoje = date("Y-m-d");
$queryPerdidos = "SELECT COUNT(*) AS lids_perdidos FROM dados_whatsapp WHERE DATE(data_coleta) = '$hoje' AND status = 'aguardando'";
$resultadoPerdidos = $mysqli->query($queryPerdidos);
if ($resultadoPerdidos) {
    $row = $resultadoPerdidos->fetch_assoc();
    $perdidos = $row['lids_perdidos'] ?? 0;
}

// Calcular os lids totais (atendidos + perdidos)
$totais = $atendidos + $perdidos;

// Inicia a variável que conterá o conteúdo da página com os valores calculados
$page_content = '
        <div class="right_col" role="main">
        <div class="page-title">
          <div class="title_left">
            <h3>Relatórios de envio</h3>
          </div>
          <div class="title_right">
            <ul class="nav navbar-right panel_toolbox">
              <li>
                <a>
                  Lids Totais: ' . $totais . ' | 
                  <span style="color: green;">Atendidos: ' . $atendidos . '</span> | 
                  <span style="color: red;">Perdidos: ' . $perdidos . '</span>
                </a>
              </li>
            </ul>
          </div>
          <div class="clearfix"></div>
        </div>

    <div class="clearfix"></div>';

// Ordenar o array pelo 'Total do dia' em ordem decrescente
uasort($totaisPorUsuario, function($a, $b) {
    return $b['totalDoDia'] <=> $a['totalDoDia'];
});

// Agora, gere o conteúdo da página com a lista ordenada
$contador = 0;

foreach ($totaisPorUsuario as $nome => $dados) {
    $totalDoDia = $dados['totalDoDia'];
    $ultimoEnvio = $dados['ultimoEnvio'];
    $sessoesHoje = $dados['sessoesHoje'];
    $mediaPorSessao = $sessoesHoje > 0 ? round($totalDoDia / $sessoesHoje, 2) : 0;

    $ultimaSessao = $dados['ultimaSessao'];
    $num_secao = $ultimaSessao['num_secao'] ?? 'Sem dados';
    $nome_usuario = $ultimaSessao['nome_usuario'] ?? null;
    $totalEnviosUltimaSessao = $ultimaSessao && $nome_usuario ? buscarTotalEnviosUltimaSessao($nome_usuario, $num_secao) : 'Sem dados';

    // Verificar se o usuário está online
    $usuariosFormatados = implode("', '", $dados['dados']['nomes']);
    $querySituacao = "SELECT `situacao` FROM `users` WHERE `nome_usuario` IN ('$usuariosFormatados')";
    $resultadoSituacao = $mysqli->query($querySituacao);
    
    $situacao = 'Offline';
    if ($resultadoSituacao) {
        while ($rowSituacao = $resultadoSituacao->fetch_assoc()) {
            if ($rowSituacao['situacao'] === 'online') {
                $situacao = 'Online';
                break;
            }
        }
    }
    
    if ($situacao === 'Online') {
        $situacao = ' <span style="background-color: #4CAF50; color: white; padding: 2px 8px; border-radius: 12px; font-size: 12px; font-weight: bold; line-height: 1; display: inline-block; vertical-align: middle;">Online</span>';
    } else {
        $situacao = ' <span style="background-color: #f44336; color: white; padding: 2px 8px; border-radius: 12px; font-size: 12px; font-weight: bold; line-height: 1; display: inline-block; vertical-align: middle;">Offline</span>';
    }
    
    // Adicionar coroa ao usuário com o maior "Total do dia"
    $iconeCoroa = '';
    if ($nome === $usuarioComMaiorTotal) {
        $iconeCoroa = ' <i class="fa fa-crown" aria-hidden="true" style="color: gold; margin-left: 5px;"></i>';
    }
    
    $page_content .= '
      <div class="col-md-6 col-sm-6 col-xs-12">
        <div class="x_panel">
          <div class="x_title">
            <h2>' . ucfirst($nome) . $iconeCoroa . $situacao . ' <small>Finais: ' . implode(', ', $dados['dados']['valores']) . '</small></h2>
            <div class="clearfix"></div>
          </div>
          <div class="x_content">
            <table class="table table-hover">
              <thead>
                <tr>
                  <th>Último Envio</th>
                  <th>Sessão Atual</th>
                  <th>Total do dia</th>
                  <th>Media por sessão</th>
                  <th>Sessões no dia</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td>' . $ultimoEnvio . '</td>
                  <td>' . $totalEnviosUltimaSessao . '</td>
                  <td>' . $totalDoDia . '</td>
                  <td>' . $mediaPorSessao . '</td>
                  <td>' . $sessoesHoje . '</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>';

    $contador++;

    // Adiciona clearfix após cada dois itens (ou seja, a cada linha completa)
    if ($contador % 2 == 0) {
        $page_content .= '<div class="clearfix"></div>';
    }
}

// Adiciona o novo bloco de conteúdo aqui
$page_content .= '
            <div class="">
            </div>

            <div class="clearfix"></div>
            
              <div class="title_left">
                <h3>Histórico</h3>
              </div>

            <div class="row">
              <div class="col-md-12 col-sm-12 col-xs-12">
                <div class="x_panel">
                  <div class="x_title">
                    <h2>Últimas 30 sessões <small>Todos</small></h2>
                    <div class="clearfix"></div>
                  </div>
                  <div class="x_content">
                    <table id="datatable-buttons" class="table table-striped table-bordered">
                      <thead>
                        <tr>
                          <th>Data</th>
                          <th>User</th>
                          <th>Sessões Criadas</th>
                          <th>Media por Sessão</th>
                          <th>Total Enviado</th>
                          <th>Lids Perdidos</th>
                        </tr>
                      </thead>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        </div>
        </div>';

// Inclui o arquivo sidebar que usará essa variável para mostrar o conteúdo
include('sidebar.php');
?>
