<?php
// Defina o conteúdo da página, incluindo a consulta ao banco de dados
$page_content = '
<meta http-equiv="refresh" content="10">
<style>
    table.table-striped.table-bordered {
        text-align: center;
    }
    table.table-striped.table-bordered th,
    table.table-striped.table-bordered td {
        text-align: center;
        vertical-align: middle;
    }
</style>
<div class="right_col" role="main">
    <div class="row">
      <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="x_panel">
          <div class="x_title">
            <h2>Puxador V 3.13 <small>Users</small></h2>
            <ul class="nav navbar-right panel_toolbox">
              <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
              </li>
              <li class="dropdown">
                <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false"><i class="fa fa-wrench"></i></a>
                <ul class="dropdown-menu" role="menu">
                  <li><a href="#">Settings 1</a>
                  </li>
                  <li><a href="#">Settings 2</a>
                  </li>
                </ul>
              </li>
              <li><a class="close-link"><i class="fa fa-close"></i></a>
              </li>
            </ul>
            <div class="clearfix"></div>
          </div>
        <div class="x_content">
        <table id="datatable" class="table table-striped table-bordered">
          <thead>
            <tr>
              <th>Data Coleta</th>
              <th>Lid</th>
              <th>Origem</th>
              <th>Nicho</th> <!-- Nova coluna Nicho -->
              <th>Status</th>
              <th>Data Envio</th>
              <th>User Envio</th>
            </tr>
          </thead>
          <tbody>';

// Conecte-se ao banco de dados e recupere os dados
$servername = "localhost";
$username = "onabet10_dashboardsodre";
$password = "Careca321@#!";
$dbname = "onabet10_sodrenetwork";
$conn = new mysqli($servername, $username, $password, $dbname);
$conn->set_charset("utf8mb4");

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Modifique a consulta para incluir o campo 'nicho'
$sql = "SELECT data_coleta, lid, origem, nicho, status, data_envio, user_envio FROM dados_whatsapp WHERE status IN ('aguardando', 'enviado', 'pendente') ORDER BY data_coleta DESC LIMIT 50";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        // Converter data para formato brasileiro
        $data_coleta = DateTime::createFromFormat('Y-m-d H:i:s', $row["data_coleta"]);
        $data_envio = DateTime::createFromFormat('Y-m-d H:i:s', $row["data_envio"]);
        
        $page_content .= "<tr>
            <td class='data-coleta'>" . ($data_coleta ? $data_coleta->format('d/m/Y H:i:s') : '') . "</td>
            <td>" . $row["lid"] . "</td>
            <td>" . $row["origem"] . "</td>
            <td>" . $row["nicho"] . "</td> <!-- Exibir o nicho --> 
            <td>" . $row["status"] . "</td>
            <td>" . ($data_envio ? $data_envio->format('d/m/Y H:i:s') : '') . "</td>
            <td>" . $row["user_envio"] . "</td>
        </tr>";
    }
} else {
    $page_content .= "<tr><td colspan='7'>No data found</td></tr>"; // Atualize colspan para 7 devido à nova coluna
}

$conn->close();

$page_content .= '
          </tbody>
        </table>
      </div>
</div>
<script>
document.addEventListener("DOMContentLoaded", function() {
    var rows = document.querySelectorAll("#datatable tbody tr");
    if (rows.length > 0) {
        var lastRow = rows[0]; // Alterado para pegar a primeira linha
        var lastDateCell = lastRow.querySelector(".data-coleta");
        if (lastDateCell) {
            var lastDateText = lastDateCell.textContent;
            console.log("Última data coletada: " + lastDateText);
            if (lastDateText) {
                var dateParts = lastDateText.split(" ");
                var date = dateParts[0].split("/");
                var time = dateParts[1].split(":");
                var lastDate = new Date(date[2], date[1] - 1, date[0], time[0], time[1], time[2]);
                
                console.log("Última data formatada: " + lastDate);
                var now = new Date();
                console.log("Data atual: " + now);
                var diffMs = (now - lastDate);
                var diffMins = Math.floor((diffMs / 1000) / 60);
                console.log("Diferença em minutos: " + diffMins);

                if (diffMins > 5) {
                    console.log("Tocando alerta sonoro");
                    var audio = new Audio("alert_sound.mp3");
                    audio.play();
                } else {
                    console.log("Nenhum alerta: diferença menor ou igual a 5 minutos");
                }
            }
        }
    } else {
        console.log("Nenhuma linha encontrada na tabela");
    }
});
</script>
';

// Inclua o template da sidebar
include 'sidebar.php';
?>
